SELECT s.name AS TABLE_SCHEMA, o.name AS TABLE_NAME,
       i.name AS INDEX_NAME, i.type_desc AS INDEX_TYPE,
       alloc_unit_type_desc AS ALLOC_UNIT_TYPE,
       avg_fragmentation_in_percent AS FRAG_PC,
       page_count AS PAGES
FROM   sys.dm_db_index_physical_stats(DB_ID(), NULL, NULL, NULL, NULL) AS ips
       INNER JOIN sys.objects AS o
             ON ips.object_id = o.object_id
       INNER JOIN sys.schemas AS s
             ON o.schema_id = s.schema_id
       LEFT OUTER JOIN sys.indexes AS i
             ON ips.object_id = i.object_id
                AND ips.index_id = i.index_id;